// Print a table of balances
public class InterestTable {
    
   // Print a table that gives balances after varying
   // number of years and at different interest rates.
   public static void main(String pars[ ]) {
      int[ ][ ] b= interestRates(10,7);
      System.out.println("Balances for various interest
                          rates,");
      System.out.println("compounded annually, rounded to
                          dollars");
      System.out.println("year  5.0%   5.5%   6.0%   6.5%"
                         + "   7.0%   7.5%   8.0%");
      printTable(b);
   }
   
   // = the balance after y (>= 0) years, starting with d
   // dollars compounded annually at an interest rate of
   // rate percent
   //   The balance is rounded to the nearest integer
   public static int balance(double d, int y, double rate)
   {
      // inv: d is the balance after i years
      for (int i= 0; i != y; i++) {
         d= d * (1 + rate/100);
      }
      return (int)(Math.round(d));
   }
   
   // = a two-dimensional array b[0..years-1][0..nRates-1]
   //   b[r][c] contains the balance after r+1 years at
   //   an interest rate of (5 + .5*c) percent, beginning
   //   with a balance of $1,000.
   public static int[ ][ ] interestRates(int years, 
                                         int nRates) {
      int[ ][ ] b= new int[years][nRates];
      // invariant b[0..r-1] and b[r][0..c-1] have been 
      // calculated
      for (int r= 0; r != b.length; r++)
         for (int c= 0; c != b[c].length; c++) {
            b[r][c]= balance(1000, r+1, 5+(.5*c));
         }
   
      return b;
   }
   
   // Print array d, one row per line
   // Precede each row by the integer 1+(row number)
   public static void printTable(int[ ][ ] d) {
      // invariant: rows 0, ..., r-1 have been printed
      for (int r= 0; r != d.length; r++) {
         // Print row d[r] on one line
            System.out.print((1 + r) + "  ");
            // inv: elements d[r, 0..c-1] have been printed
            for (int c= 0; c != d[r].length; c++) {
               System.out.print("   " + d[r][c]);
            }
            System.out.println();
      }
   }
   
}
